<?php $__env->startSection('content'); ?>
    <style>
        .tracking-box {
            background-color: white;
            border-radius: 5px;
            padding: 20px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }

        .tracking-header {
            text-align: center;
            margin-bottom: 20px;
        }

        .tracking-number {
            font-size: 1rem;
            color: #999;
            margin-bottom: 20px;
        }

        .progress-bar-container {
            margin-top: 10px;
            padding-bottom: 20px;
            text-align: center;
        }

        .progressbar {
            list-style: none;
            padding: 0;
            display: flex;
            justify-content: space-between;
            margin: 0 auto;
            max-width: 300px;
        }

        .progressbar li {
            text-align: center;
            width: 30%;
            position: relative;
            color: #bbb;
            font-size: 12px;
            font-weight: bold;
        }

        .progressbar li.active {
            color: #2295CA;
        }

        .progressbar li::before {
            content: "";
            width: 10px;
            height: 10px;
            background-color: #bbb;
            border-radius: 50%;
            display: block;
            margin: 0 auto;
            margin-bottom: 5px;
        }

        .progressbar li.active::before {
            background-color: #2295CA;
        }

        .progressbar li::after {
            content: "";
            position: absolute;
            width: 100%;
            height: 2px;
            background-color: #bbb;
            top: 5px;
            left: 50%;
            z-index: -1;
        }

        .progressbar li.active+li::after {
            background-color: #2295CA;
        }

        .status-box {
            background-color: #4CAF50;
            text-align: center;
            padding: 10px;
            margin-bottom: 20px;
            border-radius: 5px;
        }

        .status {
            color: white;
            font-size: 1.2rem;
            font-weight: bold;
        }

        .tracking-details {
            margin-top: 10px;
        }

        .timeline ul {
            padding: 0;
            list-style: none;
            position: relative;
        }

        .timeline ul li {
            padding: 15px 0;
            border-bottom: 1px solid #f0f0f0;
            position: relative;
        }

        .timeline ul li:last-child {
            border-bottom: none;
        }

        .timestamp {
            font-size: 0.9rem;
            color: #333;
        }

        .status {
            display: block;
            font-size: 1rem;
            color: #666;
            margin-top: 5px;
        }

        .location {
            color: #999;
            font-size: 0.9rem;
        }

        .usps {
            color: #666;
            font-size: 0.8rem;
        }

        .status i {
            margin-right: 10px;
            color: #2295CA;
            font-size: 1.2rem;
        }

        .blink {
            animation: blink-animation 1s steps(5, start) infinite;
            -webkit-animation: blink-animation 1s steps(5, start) infinite;
        }

        @keyframes blink-animation {
            to {
                visibility: hidden;
            }
        }

        @-webkit-keyframes blink-animation {
            to {
                visibility: hidden;
            }
        }
    </style>
    <section id="page-title" class="page-title bg-overlay bg-parallax">
        <div class="bg-img"><img src="/assets/img/page-titles/14.jpg" alt="background"></div>
        <div class="container">
            <div class="row">
                <div class="col-sm-12 col-md-12 col-lg-12">
                    <h1 class="pagetitle__heading"><?php echo e($title); ?></h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="/">Home</a></li>
                            <li class="breadcrumb-item active" aria-current="page">Track & Trace</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </section>

    <section id="trackShipmeent" class="track-shipment pb-80">
        <div class="container mt-5 mb-5">
            <div class="tracking-box">
                <div class="tracking-header">
                    <div class="tracking-number"><?php echo e($shipment->tracking_code); ?></div>
                    <div class="progress-bar-container">
                        <?php if($shipment->status == 'Delivered' || $shipment->status == 'PickedUp' || $shipment->status == 'InTransit'): ?>
                            <ul class="progressbar">
                                <?php if($shipment->status == 'PickedUp'): ?>
                                    <li class="active">Pickup</li>
                                <?php else: ?>
                                    <li>Pickup</li>
                                <?php endif; ?>

                                <?php if($shipment->status == 'InTransit'): ?>
                                    <li class="active">In Transit</li>
                                <?php else: ?>
                                    <li>In Transit</li>
                                <?php endif; ?>
                                <?php if($shipment->status == 'Delivered'): ?>
                                    <li class="active">Delivery</li>
                                <?php else: ?>
                                    <li>Delivery</li>
                                <?php endif; ?>

                            </ul>
                        <?php endif; ?>
                    </div>
                </div>
                <?php if($shipment->status == 'Delivered'): ?>
                    <div class="status-box">
                        <p class="status delivered" style="color: white">DELIVERED</p>
                    </div>
                <?php endif; ?>
                <div class="tracking-details">
                    <div class="timeline">
                        <ul>

                            <?php $__currentLoopData = $shipmentLocations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shipmentLocation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <div class="timestamp">
                                        <span class="date"><?php echo e(date('M d,Y', strtotime($shipmentLocation->date))); ?></span>
                                        <span class="time"><?php echo e(date('g:i a', strtotime($shipmentLocation->time))); ?></span>
                                    </div>

                                    <div class="status">
                                        <?php if($shipmentLocation->status == 'OutForDelivery'): ?>
                                            <i class="fas fa-truck"></i>
                                        <?php elseif($shipmentLocation->status == 'Delivered'): ?>
                                            <i class="fas fa-check-circle"></i>
                                        <?php else: ?>
                                            <i class="fas fa-box"></i>
                                        <?php endif; ?>
                                        <?php echo e($shipmentLocation->status); ?> <span
                                            class="usps">(<?php echo e($shipment->carrier); ?>)</span>
                                    </div>
                                    <?php if($shipmentLocation->description != null): ?>
                                        <div class="location"><?php echo e($shipmentLocation->description); ?>(<?php echo e($shipment->carrier); ?>)
                                        </div>
                                    <?php endif; ?>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>

                    </div>
                </div>
            </div>
        </div>
        <div class="container" style="margin-top:100px">
            <div class="row">
                <div class="col-12 mb-5">
                    <div class="row mt-5">
                        <div class="col-sm-12 col-md-5">
                            <img class="img-fluid w-75" src="/assets/img/stamp.jpeg" alt="" srcset="">
                        </div>
                        <div class="col-sm-12 col-md-7">
                            <h6>Shipping Details</h6>
                            <dl class="row">
                                <dt class="col-sm-2">From:</dt>
                                <dd class="col-sm-10">
                                    <address>
                                        <strong><?= $shipment->sender_name ?> <br></strong>
                                        <small> <span class="text-lead">Address:</span>
                                            <?= $shipment->sender_address ?></small> <br>
                                        <small> <span class="text-lead">Email:</span>
                                            <?= $shipment->sender_email ?></small> <br>
                                        <small> <span class="text-lead">Phone:</span>
                                            <?= $shipment->sender_phone ?></small>
                                    </address>
                                </dd>
                                <dt class="col-sm-2">To:</dt>
                                <dd class="col-sm-10">
                                    <address>
                                        <strong><?= $shipment->client_name ?> <br></strong>
                                        <small> <span class="text-success">Address:</span>
                                            <?= $shipment->client_address ?></small> <br>
                                        <small> <span class="text-success">Email:</span>
                                            <?= $shipment->client_email ?></small> <br>
                                        <small> <span class="text-success">Phone:</span>
                                            <?= $shipment->client_phone ?></small>
                                    </address>
                                </dd>
                            </dl>
                        </div>
                        <div class="col-sm-12 col-md-12">
                            <dl class="row">
                                <dt class="col-sm-2 text-lead">Description:</dt>
                                <dd class="col-sm-10"><?= $shipment->description ?></dd>
                                <dt class="col-sm-2 text-lead">Status:</dt>
                                <dd class="col-sm-10 blink text-danger"><?= $shipment->status ?></dd>
                                <dt class="col-sm-12 text-lead">Shipped from:</dt>
                                <dd class="col-sm-12"><?= $shipment->shipped_from ?></dd>
                                <dt class="col-sm-12 text-lead">Shipped to:</dt>
                                <dd class="col-sm-12"><?= $shipment->pickup_location ?></dd>
                                <dt class="col-sm-12 text-lead">Expected Date of Delivery:</dt>
                                <dd class="col-sm-12">
                                    <?= $shipment->expected_delivery_date ?> </dd>
                                <dt class="col-sm-12 text-lead">Pickup Location:</dt>
                                <dd class="col-sm-12"><?= $shipment->pickup_location ?></dd>
                                <dt class="col-sm-12 text-lead">Date of Shipment:</dt>
                                <dd class="col-sm-12">
                                    <?= $shipment->date_of_shipment ?> </dd>
                                <dt class="col-sm-12 text-lead">Shipped by:</dt>
                                <dd class="col-sm-12"><?= config('app.name') ?></dd>
                            </dl>
                        </div>
                    </div>
                    <div class="col-12">
                        <h5>Location History </h5>
                        <ul class="list-group">
                            <?php if($shipmentLocations): ?>
                                <?php $__currentLoopData = $shipmentLocations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shipmentLocation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="row">
                                        <div class="col-12">
                                            <li
                                                class="list-group-item mb-1 <?php echo e($shipment->status == $shipmentLocation->status && $shipment->current_location == $shipmentLocation->location ? 'bg-success' : 'text-secondary text-white'); ?> text-white">
                                                <address>
                                                    <p
                                                        class="m-0 p-0 <?php echo e($shipment->status == $shipmentLocation->status && $shipment->current_location == $shipmentLocation->location ? 'blink' : ''); ?> ">
                                                        <?php echo e($shipment->status == $shipmentLocation->status && $shipment->current_location == $shipmentLocation->location ? " Current location: $shipmentLocation->location" : "Previous location: $shipmentLocation->location"); ?>

                                                    </p>
                                                    <small class="">
                                                        <?php echo e($shipmentLocation->date); ?></small><br>
                                                    <small><?php echo e($shipmentLocation->status); ?></small>
                                                </address>
                                            </li>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <div class="alert alert-warning" role="alert">
                                    No location history
                                </div>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="row mt-5">
                <div class="container" style="margin-bottom:100px;">
                    <div class="mapouter">
                        <div class="gmap_canvas"><iframe class="gmap_iframe" frameborder="0" scrolling="no" marginheight="0"
                                marginwidth="0"
                                src="https://maps.google.com/maps?width=600&amp;height=400&amp;hl=en&amp;q=<?php echo e(ucfirst($shipment->current_location)); ?>&amp;t=&amp;z=14&amp;ie=UTF8&amp;iwloc=B&amp;output=embed"></iframe><a
                                href="https://gachanymph.com/">Gacha Nymph</a></div>
                        <style>
                            .mapouter {
                                position: relative;
                                text-align: right;
                                width: 100%;
                                height: 400px;
                            }

                            .gmap_canvas {
                                overflow: hidden;
                                background: none !important;
                                width: 100%;
                                height: 400px;
                            }

                            .gmap_iframe {
                                width: 100% !important;
                                height: 400px !important;
                            }
                        </style>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\logistics-v3.1\resources\views\pages\cargo_tracking_details.blade.php ENDPATH**/ ?>