<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\Auth\NewPasswordController;
use App\Http\Controllers\Auth\PasswordResetLinkController;
use App\Http\Controllers\Dashboard\Master\AdminController;
use App\Http\Controllers\Dashboard\Admin\ContactController;
use App\Http\Controllers\Dashboard\Admin\ShipmentController;
use App\Http\Controllers\Dashboard\Master\ProfileController;
use App\Http\Controllers\Auth\AuthenticatedSessionController;
use App\Http\Controllers\Dashboard\Admin\DashboardController;
use App\Http\Controllers\Dashboard\Admin\ShipmentLocationController;
use App\Http\Controllers\Dashboard\Master\DashboardController as MasterDashboardController;

Route::get('/', [HomeController::class, 'index'])->name('home');
Route::get('/about', [PageController::class, 'about'])->name('about');
Route::get('/contact', [PageController::class, 'contact'])->name('contact');
Route::post('/contact/store', [PageController::class, 'contactStore'])->name('contact.store');
Route::get('/services', [PageController::class, 'services'])->name('services');
Route::get('/faq', [PageController::class, 'faq'])->name('faq');
Route::get('/cargo/tracking', [PageController::class, 'cargoTracking'])->name('cargo.tracking');
Route::post('/cargo/tracking/store', [PageController::class, 'cargoTrackingStore'])->name('cargo.tracking.store');
Route::get('/cargo/tracking/details/{uuid}', [PageController::class, 'cargoTrackingDetail'])->name('cargo.tracking.details');

Route::middleware('guest')->group(function () {
    Route::get('/login', [AuthenticatedSessionController::class, 'create'])
        ->name('login');

    Route::post('/login', [AuthenticatedSessionController::class, 'store']);

    Route::get('/forgot/password', [PasswordResetLinkController::class, 'create'])
        ->name('password.request');

    Route::post('/forgot/password', [PasswordResetLinkController::class, 'store'])
        ->name('password.email');

    Route::get('/reset/password/{token}', [NewPasswordController::class, 'create'])
        ->name('password.reset');

    Route::post('/reset/password', [NewPasswordController::class, 'store'])
        ->name('password.store');
});

Route::get('/logout', [AuthenticatedSessionController::class, 'destroy'])
    ->name('logout');

Route::middleware('admin')->name('admin.')->prefix('admin')->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    Route::get('/dashboard/profile', [DashboardController::class, 'profile'])->name('dashboard.profile');
    Route::post('/dashboard/profile/update', [DashboardController::class, 'profileUpdate'])->name('dashboard.profile.update');
    // Shipment
    Route::get('/shipment/index', [ShipmentController::class, 'index'])->name('shipment.index');
    Route::get('/shipment/create', [ShipmentController::class, 'create'])->name('shipment.create');
    Route::post('/shipment/store', [ShipmentController::class, 'store'])->name('shipment.store');
    Route::get('/shipment/show/{uuid}', [ShipmentController::class, 'show'])->name('shipment.show');
    Route::get('/shipment/edit/{uuid}', [ShipmentController::class, 'edit'])->name('shipment.edit');
    Route::post('/shipment/update/{uuid}', [ShipmentController::class, 'update'])->name('shipment.update');
    Route::get('/shipment/delete/{uuid}', [ShipmentController::class, 'delete'])->name('shipment.delete');
    Route::get('/shipment/print/{uuid}', [ShipmentController::class, 'print'])->name('shipment.print');
    // Shipment location
    Route::post('/shipment/location/store/{uuid}', [ShipmentLocationController::class, 'store'])->name('shipment.location.store');
    Route::get('/shipment/location/delete/{uuid}', [ShipmentLocationController::class, 'delete'])->name('shipment.location.delete');
    // Contact
    Route::get('/contact/index', [ContactController::class, 'index'])->name('contact.index');
    Route::get('/contact/show/{uuid}', [ContactController::class, 'show'])->name('contact.show');
    Route::post('/contact/send/{uuid}', [ContactController::class, 'send'])->name('contact.send');
    Route::get('/contact/delete/{uuid}', [ContactController::class, 'delete'])->name('contact.delete');
});
Route::middleware('master')->name('master.')->prefix('master')->group(function () {
    Route::get('/dashboard', [MasterDashboardController::class, 'index'])->name('dashboard');
    // Admin controller
    Route::get('/admin/index', [AdminController::class, 'index'])->name('admin.index');
    Route::get('/admin/register', [AdminController::class, 'register'])->name('admin.register');
    Route::post('/admin/store', [AdminController::class, 'store'])->name('admin.store');
    Route::get('/admin/edit/{uuid}', [AdminController::class, 'edit'])->name('admin.edit');
    Route::post('/admin/update/{uuid}', [AdminController::class, 'update'])->name('admin.update');
    // Profile controller
    Route::get('/profile/index', [ProfileController::class, 'index'])->name('profile.index');
    Route::post('/profile/update', [ProfileController::class, 'update'])->name('profile.update');
});
