@extends('layouts.master')
@section('content')
    <section id="page-title" class="page-title bg-overlay bg-parallax">
        <div class="bg-img"><img src="/assets/img/page-titles/14.jpg" alt="background"></div>
        <div class="container">
            <div class="row">
                <div class="col-sm-12 col-md-12 col-lg-12">
                    <h1 class="pagetitle__heading">Track & Trace</h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="/">Home</a></li>
                            <li class="breadcrumb-item"><a href="#">Features</a></li>
                            <li class="breadcrumb-item active" aria-current="page">Track & Trace</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </section>

    <section id="trackShipmeent" class="track-shipmeent pb-80">
        <div class="container">
            <div class="row">
                <div class="col-sm-12 col-md-12 col-lg-4">
                    <aside class="sidebar mb-30">
                        <div class="widget widget-help bg-overlay bg-overlay-grdient-secondary">
                            <div class="bg-img"><img src="/assets/img/sidebar/1.jpg" alt="background"></div>
                            <div class="widget__content">
                                <h5>How Can <br> We Help You!</h5>
                                <p>We understand the importance approaching each work integrally and believe in the power of
                                    simple
                                    and easy communication.</p>
                            </div>
                        </div>
                    </aside>
                </div>
                <div class="col-sm-12 col-md-12 col-lg-8">
                    <div class="row mb-30">
                        <div class="col-sm-12 col-md-12 col-lg-12">
                            @if (session()->has('success'))
                                <div class="alert bg-success text-center">{{ session()->get('success') }}</div>
                            @elseif (session()->has('error'))
                                <div class="alert bg-danger text-center">{{ session()->get('error') }}</div>
                            @endif
                            <h5 class="widget__title">{{ config('app.name') }} Online Tracking Services</h5>
                            <p class="fz-16 mb-45">
                                When you track your shipment on {{ config('app.name') }}, you get the latest status and
                                estimated
                                delivery date. And while you don’t need to log in to see this information, you can get
                                more details, like reference numbers and C.O.D. requirements, and take action on
                                packages you’ve sent when you’re logged in.
                            </p>
                        </div>
                        <div class="col-sm-12 col-md-12 col-lg-12">
                            @if ($errors->any())
                                <div class="alert bg-danger">
                                    <ul>
                                        @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif

                            <form action="{{ route('cargo.tracking.store') }}" method="post">
                                @csrf
                                <div class="form-group">
                                    <label>Tracking Number</label>
                                    <div class="form-group">
                                        <input type="text" name="tracking_code" class="form-control" placeholder=""
                                            aria-describedby="helpId">
                                    </div>
                                    <button type="submit" class="btn btn__secondary btn__block">Track & Trace</button>
                                </div>
                            </form>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
