<?php

namespace App\Http\Controllers\Auth;

use App\Models\Admin;
use Illuminate\Support\Str;
use App\Helpers\AdminHelper;
use Illuminate\Http\Request;
use App\Mail\PasswordResetLink;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Mail;

class PasswordResetLinkController extends Controller
{

    public function create()
    {
        return view('auth.forgot_password', ['title' => 'Forgot Password']);
    }


    public function store(Request $request)
    {
        $request->validate([
            'email' => ['required', 'email'],
        ]);

        $admin = Admin::where('email', $request->email)->first();

        if (!$admin) {
            return back()->withErrors(['email' => 'No user found with this email.']);
        }

        $token = Str::random(64);

        $admin->password_reset_token = $token;
        $admin->save();

        $passwordResetLink = route('password.reset', ['token' => $admin->password_reset_token, 'email' => $admin->email]);

        AdminHelper::mailConfig($admin->id);

        try {
            Mail::to($admin->email)->send(new PasswordResetLink($admin, $passwordResetLink, 'My' . ' ' . config('app.name') . ' :: Password Reset Link' . ' ' . now()));
            return redirect()->back()->with('success', 'Password reset link sent successfully. Please check your email.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'An error occurred while attempting to send the email. Please try again later.');
        }
    }
}
